IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cbtes_Lotes_Cobranza]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cbtes_Lotes_Cobranza] 
END
GO
CREATE PROCEDURE [dbo].[CP_Cbtes_Lotes_Cobranza]
	@pLote				VARCHAR(29),
	@pFecha				DATETIME,
	@pDescripcion		VARCHAR(50),
	@pId_Lote_Tipo		SMALLINT,
	@pId_Periodo_Caja	INT,
	@pFecha_Rec			DATETIME,
	@pId_Tipo_Cbte		CHAR(4),
	@pId_Moneda			CHAR(3),
	@pCotizacion		DECIMAL(9, 4),
	@pId_Tipo_Val		CHAR(3),
	@pImporte			DECIMAL(16,2),
	@pUsuario			INT,
	@pId_Tarjeta        VARCHAR(10),
	@pId_Cta_banco      INT,
	@pId_Cobrador		VARCHAR(10) /*21/05/2020 Agregado x Ticket 19.849*/
AS
SET NOCOUNT ON

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Id_Cliente		INT
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Trans_Rec		INT
		,@CursorOpen        INT
		,@Flag_Cbte_Tipo	SMALLINT
		,@Sql               VARCHAR(5000)
		,@Imp_SP            VARCHAR(1000) 


  DECLARE @Respuesta Table (
				ErrorNumber		INT,
				ErrorSeverity	INT,
				ErrorState		INT,
				ErrorProcedure  VARCHAR(1000),
				ErrorLine		INT,
				ErrorMessage	VARCHAR(1000)
				)

BEGIN TRY


	/*Agregar Lote con fecha de inicio y [Flag_enProceso] en 1 */

	INSERT INTO Cbtes_Lotes (Lote,Fecha,Descripcion,Id_Lote_Tipo,Flag_enProceso,Fecha_Inicio)
		VALUES (@pLote,@pFecha,@pDescripcion,@pId_Lote_Tipo,1,GETDATE())



	/*Recorrer los tagueados */

	DECLARE TagCbtesCursor CURSOR FOR
		SELECT T.Ptr AS Id_Trans, C.Id_Cliente,T.Importe , C.Email_Cob
				FROM TagFile_ T , Clientes C
				WHERE Tbl = 300 AND Usr = @pUsuario
				AND C.Id_Cliente = CAST(T.Val AS INT)

	OPEN TagCbtesCursor

	FETCH NEXT FROM TagCbtesCursor INTO @Id_Trans,@Id_Cliente,@Importe,@Email_Cob
	SET @CursorOpen = 0	
	SET @UltError = 0
	WHILE @@FETCH_STATUS=0 AND @UltError  = 0
	BEGIN
	        SET @CursorOpen = 1	

		    SET @Id_Trans_Rec = 0

			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CP_Cbtes_Rec_Generar @pUsuario, @Id_Cliente,@Email_Cob,@pId_Periodo_Caja,@pFecha_Rec,@Importe,@pId_Tipo_Cbte,@pId_Moneda,@pCotizacion,@pLote, @pId_Cobrador
			IF @UltError <> 0
				BEGIN
					ROLLBACK
					SELECT * FROM @Respuesta	
					RETURN 4567
				END
			ELSE	
				SELECT TOP 1 @Id_Trans_Rec = ErrorLine FROM @Respuesta

            IF @Id_Trans_Rec = 0
			BEGIN
				ROLLBACK
				SELECT	 4568			AS ErrorNumber 
						,0				AS ErrorSeverity  
						,0				AS ErrorState 
						,0				AS ErrorProcedure  
						,0				AS ErrorLine		
						,'No se genero el numero de trans recibo'		AS ErrorMessage
				RETURN 4568
			END


			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CP_Cbtes_Rec_Generar_Item @Id_Trans_Rec,1,'',1,@Id_Trans,@Importe
			IF @UltError <> 0
			BEGIN
				ROLLBACK
				SELECT * FROM @Respuesta	
				RETURN 4569
			END


			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CP_Cbtes_Rec_Generar_Pago @Id_Trans_Rec,@pId_Tipo_Val,0,@pFecha_Rec,@pFecha_Rec,@pFecha_Rec,@pFecha_Rec,@Importe,@pId_Tarjeta,'',NULL,'','',0,@pId_Cta_banco
			IF @UltError <> 0
			BEGIN
				ROLLBACK
				SELECT * FROM @Respuesta	
				RETURN 4570
			END

			
			
			DELETE @Respuesta
			INSERT INTO @Respuesta
			EXEC @UltError = CP_Cbtes_Rec_Fin @Id_Trans_Rec
			
			IF @UltError <> 0
			BEGIN
				ROLLBACK
				SELECT * FROM @Respuesta	
				RETURN 4571
			END
			
				
   			FETCH NEXT FROM TagCbtesCursor INTO @Id_Trans,@Id_Cliente,@Importe,@Email_Cob	

	END
	CLOSE TagCbtesCursor
	DEALLOCATE TagCbtesCursor
	SET @CursorOpen = 0	

	/*Actualizar Lote con fecha de fin y [Flag_enProceso] en 0 y totales */
	UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
							Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
							Fecha_Finalizacion = GETDATE(),
							Flag_enProceso = 0
			WHERE Lote = @pLote
			
	/*CURSOR DE LOS CBTES DEL LOTE */
	/*  Ahora lo hace CP_Cbtes_Rec_Fin         9/9/2020 Gaby

    SELECT @Imp_SP = ISNULL(Imp_Sp,'') FROM CBTES_TIPOS WHERE ID_TIPO_CBTE = @pId_Tipo_Cbte
	
	IF @Imp_SP <> ''
	BEGIN	

		DECLARE Cursor_Fact_Pro CURSOR FOR
		SELECT c.Id_Trans
		FROM cbtes c
		WHERE c.lote = @pLote
		
		
		OPEN Cursor_Fact_Pro
		FETCH NEXT FROM Cursor_Fact_Pro INTO  @Id_trans
		WHILE @@FETCH_STATUS = 0
		BEGIN	

		    SET @sql = 'EXEC '+ LTRIM(RTRIM(@Imp_SP)) +' '+ CAST(@Id_Trans AS VARCHAR(10))

			EXEC(@sql)
			
		FETCH NEXT FROM Cursor_Fact_Pro INTO @Id_Trans
		END
		CLOSE Cursor_Fact_Pro
		DEALLOCATE Cursor_Fact_Pro
	END
	*/
	/*FIN */
		
	/******************************fin del proceso***********************************************/


	/*******************    En caso de error deberia grabar en la tablla cbtes_errores ***********************/

	


	SET @Mensaje = (SELECT DATEDIFF(s,Fecha_Inicio,Fecha_Finalizacion) FROM CBTES_LOTES WHERE LOTE = @pLote)

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage
END TRY  


BEGIN CATCH  
    
    EXECUTE usp_GetErrorInfo
	
	UPDATE Cbtes_Lotes SET	Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote) ,
							Importe =  (SELECT SUM(Imp_Total) FROM Cbtes WHERE Lote = @pLote),
							Fecha_Finalizacion = GETDATE(),
							Flag_enProceso = 0
			WHERE Lote = @pLote

      IF @CursorOpen = 1
	     BEGIN 
		 	CLOSE TagCbtesCursor
	        DEALLOCATE TagCbtesCursor
         END
		 	
	RETURN 9999
END CATCH

RETURN 0
